;(function($) {
	WooPackCheckout = function( settings ) {
		this.id      = settings.id;
		this.wrapper = $('.fl-node-' + this.id + ' .woopack-checkout');

		this.init();
	};

	WooPackCheckout.prototype = {
		id: '',
		wrapper: '',

		init: function() {
			if ( this.isEnhancedStyle() && this.wrapper.find( 'button[name="apply_coupon"]' ).length > 0 ) {
				this.wrapper.on( 'click', 'button[name="apply_coupon"]', this.applyCoupon.bind( this ) );
			}
		},

		isEnhancedStyle: function() {
			return this.wrapper.hasClass( 'style-enhanced' );
		},

		applyCoupon: function(e) {
			e.preventDefault();

			var self = this;

			var data = {
				security: wc_checkout_params.apply_coupon_nonce,
			    coupon_code: this.wrapper.find( 'input[name="coupon_code"]' ).val()
			}

			var $couponBox = this.wrapper.find( '.woopack-checkout-coupon' );

			this.startProcessing( $couponBox );
			
			$.ajax({
				type: 'post',
				url: wc_checkout_params.wc_ajax_url.toString().replace('%%endpoint%%', 'apply_coupon'),
				data: data,
				dataType: 'html',
				success: function( code ) {
					$('.woocommerce-error, .woocommerce-message').remove();
        			$couponBox.removeClass('processing').unblock();
					self.wrapper.find( 'form.woocommerce-checkout' ).before( code );
					self.wrapper.find( '.checkout_coupon' ).slideUp();
					$( document.body ).trigger( 'applied_coupon_in_checkout', [data.coupon_code] );
					$( document.body ).trigger( 'update_checkout', {
						update_shipping_method: false
					} );
				}
			});
		},

		startProcessing: function( $form ) {
			if ( $form.is('.processing') ) {
				return;
			}
		  
			/**
			 * .block() is from a jQuery blockUI plugin loaded by WooCommerce. This code is based on WooCommerce
			 * core in order for the Checkout widget to behave the same as WooCommerce Checkout pages.
			 */
			$form.addClass('processing').block({
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6
				}
			});
		}
	};
})(jQuery);